
#version 120

varying vec3 normal;
varying vec3 tangent;
varying vec3 binormal;

uniform vec3 lightNormal;
uniform sampler2D ntex;
uniform sampler2D lightProbe;

void main()
{
	vec4 nmap = texture2D(ntex, gl_TexCoord[0].st) - 0.5;
	//vec4 color = mix(vec4(0.332,0.671,0.874,1), vec4(0.04154,0.107,0.382,1), clamp(dot(normalize(normal), normalize(lightNormal)), 0, 1));
	vec3 n = normalize((normal * nmap.z) + (tangent * nmap.y) + (binormal * nmap.x));
	vec4 color = mix(vec4(0.3,0.3,0.3,1), vec4(0.8,0.8,0.8,1), clamp(dot(n, normalize(lightNormal)), 0, 1));
	gl_FragColor = mix(color, color * texture2D(lightProbe, n.xy * 0.5 + 0.5), 0.8);//clamp(color, vec4(0,0,0,0), vec4(1,1,1,1));//mix(gl_Color, color, 0.5);  + gl_Color
	//gl_FragColor = color;
}
